##################################################################
# R code: Exercise 2.11(b) first part
# File: Friedman's_supersmoother.r
#
# Friedman's supersmoother. This code is a modified version of 
# S-Plus code provided by Tess Astatkie. 
# INPUT:  jokulsa.dat (1,086 * 32) matrix 
# OUTPUT: Plot of Friedman's supersmoother: Q on AvT 
##################################################################
x        <- jokulsa
x[,33]   <- (x[,24]+x[,25]+x[,26])/3  # Average temperature (AvT)
names(x) <- c("Q","Q1","Q2","Q3","Q4","Q5","Q6","Q7","Q8",
  "Q9","Q10","P","P1","P2","P3","P4","P5","P6","P7",
  "P8","P9","P10","Tm","T1","T2","T3","T4","T5","T6",
  "T7","T8","T9","AvT")
x   <- x[x[,3] <= 92, ]
x1x <- supsmu(x[,33],x[,1])$x   # Friedman's supersmoother
x1y <- supsmu(x[,33],x[,1])$y
plot(x1x,x1y)
